/*
 *  $Id: connectionRTSP.h,v 1.7 2010/07/19 13:49:31 schmirl Exp $
 */

#ifndef VDR_STREAMDEV_SERVERS_CONNECTIONRTSP_H
#define VDR_STREAMDEV_SERVERS_CONNECTIONRTSP_H

#include "connection.h"
#include "server/livestreamer.h"
#include "server/recstreamer.h"

#include <map>
#include <tools/select.h>

class cChannel;
class cMenuList;

class cConnectionRTSP: public cServerConnection {
private:
	enum eRTSPStatus {
		hsRequest,
		hsHeaders,
		hsBody,
		hsFinished,
	};

	eRTSPStatus                       m_Status;
	tStrStrMap                        m_Params;
	// job: transfer
	const cChannel                   *m_Channel;
	int                               m_Apid[2];
	int                               m_Dpid[2];

	bool ProcessURI(const std::string &PathInfo);
	bool RtspResponse(int Code, bool Last, const char* ContentType = NULL, const char* Headers = "", ...);
protected:
	bool ProcessRequest(void);

public:
	cConnectionRTSP(void);
	virtual ~cConnectionRTSP();

	virtual cString ToText(char Delimiter = ' ') const;

	virtual bool Command(char *Cmd);

	virtual bool Abort(void) const;
	virtual void Flushed(void);
};

inline bool cConnectionRTSP::Abort(void) const
{
	return !IsOpen() || (Streamer() && Streamer()->Abort());
}

#endif // VDR_STREAMDEV_SERVERS_CONNECTIONRTSP_H
